#include <stdio.h>
#define UM_NDIS685

#include <Packet32.h>
#pragma comment(lib, "packet.lib")

#include <ntddndis.h>
#include <tchar.h>
BOOL LoadNpcapDlls()
{
	TCHAR npcap_dir[512];
	UINT len;
	len = GetSystemDirectory(npcap_dir, 480);
	if (!len) {
		_ftprintf(stderr, _T("Error in GetSystemDirectory: %x"), GetLastError());
		return FALSE;
	}
	_tcscat_s(npcap_dir, 512, _T("\\Npcap"));
	if (SetDllDirectory(npcap_dir) == 0) {
		_ftprintf(stderr, _T("Error in SetDllDirectory: %x"), GetLastError());
		return FALSE;
	}
	return TRUE;
}

VOID hexDump(PVOID pMem, ULONG Len)
{
	PUCHAR data = (PUCHAR) pMem;
	for (ULONG i=0; i < Len; i++) {
		if (i % 4 == 0) {
			if (i % 8 == 0) {
				_tprintf(_T("\n%04X "), i);
			}
			else {
				_tprintf(_T(" "));
			}
		}
		_tprintf(_T(" %02x"), data[i]);
	}
	_tprintf(_T("\n"));
}

DWORD doPacketGetInfo(LPADAPTER pAd, ULONG ulID, PVOID pInfo, ULONG infoLen)
{
	PUCHAR IoCtlBuffer = NULL;
	PPACKET_OID_DATA  OidData = NULL;
	DWORD dwResult = ERROR_INVALID_DATA;

	// 0xffff is completely arbitrary, but works as a safeguard
	if (pInfo == NULL || infoLen < sizeof(ULONG) || infoLen > 0xffff) {
		return ERROR_INVALID_DATA;
	}

	IoCtlBuffer = (PUCHAR) HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY,
		       	PACKET_OID_DATA_LENGTH(infoLen));
	if (IoCtlBuffer == NULL) {
		return GetLastError();
	}

	OidData = (PPACKET_OID_DATA) IoCtlBuffer;
	OidData->Oid = ulID;
	OidData->Length = infoLen;
	CopyMemory(OidData->Data, pInfo, infoLen);
	if (!PacketGetInfo(pAd, OidData)) {
		HeapFree(GetProcessHeap(), 0, IoCtlBuffer);
		return GetLastError();
	}
	CopyMemory(pInfo, OidData->Data, infoLen);
	HeapFree(GetProcessHeap(), 0, IoCtlBuffer);
	return ERROR_SUCCESS;
}

VOID printAdapters()
{
	const char *name, *desc;
	char *AdapterNames;
	ULONG NameLength;

	NameLength = 0;
	if (!PacketGetAdapterNames(NULL, &NameLength))
	{
		DWORD last_error = GetLastError();

		if (last_error != ERROR_INSUFFICIENT_BUFFER)
		{
			_tprintf(_T("PacketGetAdapterNames(NULL) error: (%08x)\n"),
					last_error
				);
			return;
		}
	}

	if (NameLength <= 0)
		return;
	AdapterNames = (char*) HeapAlloc(GetProcessHeap(), HEAP_ZERO_MEMORY, NameLength);
	if (AdapterNames == NULL)
	{
		_tprintf(_T("HeapAlloc error: (%08x)\n"),
				GetLastError()
			);
		return;
	}

	if (!PacketGetAdapterNames(AdapterNames, &NameLength)) {
		_tprintf(_T("PacketGetAdapterNames(NULL) error: (%08x)\n"),
				GetLastError()
			);
		HeapFree(GetProcessHeap(), 0, AdapterNames);
		return;
	}

	desc = AdapterNames;
	while (*desc != '\0' || *(desc + 1) != '\0')
		desc++;

	desc += 2;

	name = &AdapterNames[0];
	while (*name != '\0') {
		LPADAPTER dev = NULL;
		_tprintf(_T("%hs (%hs)\n"), name, desc);
		if (PacketIsLoopbackAdapter(name)) {
			goto next_name;
		}

		dev = PacketOpenAdapter(name);
		if (dev != NULL) {
			BOOLEAN Status = FALSE;
			size_t data_length = max(sizeof(NDIS_LINK_STATE), sizeof(NDIS_STATISTICS_INFO));
			data_length = max(data_length, sizeof(NDIS_RSC_STATISTICS_INFO));
			//data_length = max(data_length, sizeof(IP_OFFLOAD_STATS));
			data_length = max(data_length, sizeof(NDIS_OFFLOAD));
			//data_length = max(data_length, sizeof(NDIS_INTERRUPT_MODERATION_PARAMETERS));
			data_length = max(data_length, sizeof(NDIS_TIMESTAMP_CAPABILITIES));
			PPACKET_OID_DATA OidData = (PPACKET_OID_DATA) HeapAlloc(
					GetProcessHeap(),
					HEAP_ZERO_MEMORY,
					PACKET_OID_DATA_LENGTH(data_length)
					);
			if (OidData == NULL) {
				goto next_name;
			}

#define DO_OID_READ(_Oid, _StrOid, _Pre, _Block, _Length) do { \
	_Pre; \
	OidData->Oid = _Oid; \
	OidData->Length = _Length; \
	Status = PacketRequest(dev, FALSE, OidData); \
	if (Status) { \
		_tprintf(_T( _StrOid ": ")); \
		_Block; \
	} \
	else { \
		DWORD err = GetLastError(); \
		switch (err) { \
			case 0xe0010017: \
				_tprintf(_T( _StrOid " error: NDIS_STATUS_INVALID_OID\n")); \
				break; \
			case 0xe00000BB: \
				_tprintf(_T( _StrOid " error: STATUS_NOT_SUPPORTED\n")); \
				break; \
			case 0xe0000001: \
				_tprintf(_T( _StrOid " error: STATUS_INVALID_DEVICE_REQUEST\n")); \
				break; \
			case 0x00000001: \
				_tprintf(_T( _StrOid " error: ERROR_INVALID_FUNCTION\n")); \
				break; \
			default: \
				_tprintf(_T( _StrOid " error: %08x\n"), err); \
				break; \
		} \
	} \
} while (0);

#define DO_OID_READ_ULONG(_Oid) DO_OID_READ(_Oid, #_Oid, ZeroMemory(OidData->Data, data_length),  \
	       	_tprintf(_T("%08x\n"), *(ULONG *)OidData->Data), \
	       	sizeof(ULONG))

#define NOP (void)0
#define DO_OID_READ_HEXDUMP(_Oid, _Length, _Extra) DO_OID_READ(_Oid, #_Oid, do { \
	ZeroMemory(OidData->Data, data_length); \
	_Extra; \
	} while (0);, \
		hexDump(OidData->Data, OidData->Length), \
		_Length)

			DO_OID_READ_ULONG(OID_GEN_DRIVER_VERSION);
			USHORT NdisVersion = *(USHORT *)OidData->Data;
			DO_OID_READ_ULONG(OID_GEN_RCV_OK);
			DO_OID_READ_ULONG(OID_GEN_RCV_NO_BUFFER);
			DO_OID_READ_ULONG(OID_GEN_RECEIVE_BUFFER_SPACE);
			DO_OID_READ_ULONG(OID_GEN_RECEIVE_BLOCK_SIZE);
			DO_OID_READ_ULONG(OID_GEN_XMIT_OK);
			DO_OID_READ_ULONG(OID_GEN_TRANSMIT_BUFFER_SPACE);
			DO_OID_READ_ULONG(OID_GEN_TRANSMIT_QUEUE_LENGTH);
			DO_OID_READ_ULONG(OID_GEN_TRANSMIT_BLOCK_SIZE);

			DO_OID_READ_ULONG(OID_GEN_CURRENT_PACKET_FILTER);
			DO_OID_READ_ULONG(OID_GEN_MAXIMUM_TOTAL_SIZE);
			DO_OID_READ_ULONG(OID_GEN_CURRENT_LOOKAHEAD);

#define SET_NDIS_OBJ(_Type, _Rev, _Size) do { \
	((NDIS_OBJECT_HEADER *)(OidData->Data))->Type = _Type; \
	((NDIS_OBJECT_HEADER *)(OidData->Data))->Revision = _Rev; \
	((NDIS_OBJECT_HEADER *)(OidData->Data))->Size = _Size; \
} while (0);

			//DO_OID_READ_HEXDUMP(OID_IP4_OFFLOAD_STATS, sizeof(IP_OFFLOAD_STATS));
			//DO_OID_READ_HEXDUMP(OID_IP6_OFFLOAD_STATS, sizeof(IP_OFFLOAD_STATS));
			DO_OID_READ_HEXDUMP(OID_TCP_OFFLOAD_CURRENT_CONFIG,
					sizeof(NDIS_OFFLOAD),
					SET_NDIS_OBJ(NDIS_OBJECT_TYPE_OFFLOAD,
						NDIS_OFFLOAD_REVISION_6,
						NDIS_SIZEOF_NDIS_OFFLOAD_REVISION_6));

			DO_OID_READ_ULONG(OID_GEN_PHYSICAL_MEDIUM_EX);
			DO_OID_READ_HEXDUMP(OID_GEN_MEDIA_IN_USE, 3 * sizeof(ULONG), NOP);

			DO_OID_READ_HEXDUMP(OID_GEN_LINK_STATE,
					sizeof(NDIS_LINK_STATE),
					SET_NDIS_OBJ(NDIS_OBJECT_TYPE_DEFAULT,
						NDIS_LINK_STATE_REVISION_1,
						NDIS_SIZEOF_LINK_STATE_REVISION_1));

			DO_OID_READ_HEXDUMP(OID_GEN_STATISTICS,
					sizeof(NDIS_STATISTICS_INFO),
					SET_NDIS_OBJ(NDIS_OBJECT_TYPE_DEFAULT,
						NDIS_STATISTICS_INFO_REVISION_1,
						NDIS_SIZEOF_STATISTICS_INFO_REVISION_1));

			DO_OID_READ_HEXDUMP(OID_TCP_RSC_STATISTICS,
					sizeof(NDIS_RSC_STATISTICS_INFO),
					SET_NDIS_OBJ(NDIS_OBJECT_TYPE_DEFAULT,
						NDIS_RSC_STATISTICS_REVISION_1,
						NDIS_SIZEOF_RSC_STATISTICS_REVISION_1));

			/* // Always fails?
			DO_OID_READ_HEXDUMP(OID_GEN_INTERRUPT_MODERATION,
					sizeof(NDIS_INTERRUPT_MODERATION_PARAMETERS),
					SET_NDIS_OBJ(NDIS_OBJECT_TYPE_DEFAULT,
						NDIS_INTERRUPT_MODERATION_PARAMETERS_REVISION_1,
						NDIS_SIZEOF_INTERRUPT_MODERATION_PARAMETERS_REVISION_1));
						*/

			DO_OID_READ_HEXDUMP(OID_TIMESTAMP_CAPABILITY,
					sizeof(NDIS_TIMESTAMP_CAPABILITIES),
					SET_NDIS_OBJ(NDIS_OBJECT_TYPE_DEFAULT,
						NDIS_TIMESTAMP_CAPABILITIES_REVISION_1,
						NDIS_SIZEOF_TIMESTAMP_CAPABILITIES_REVISION_1));

#ifdef NPF_GETINFO_MODDBG
			ULONG ulInfo = 0;
			DWORD err = ERROR_SUCCESS;
#define MODDBG(_SubName) do { \
	ulInfo = _SubName; \
	err = doPacketGetInfo(dev, NPF_GETINFO_MODDBG, &ulInfo, sizeof(ulInfo)); \
	if (err == ERROR_SUCCESS) { \
		_tprintf(_T( #_SubName ": %08x\n"), ulInfo); \
	} \
	else { \
		_tprintf(_T("PacketGetInfo(NPF_GETINFO_MODDBG / " #_SubName ") error: %08x\n"), \
				GetLastError()); \
	} \
} while (0);

			MODDBG(NPF_MODDBG_PF_SUPPORTED);
			MODDBG(NPF_MODDBG_PF_MY);
			MODDBG(NPF_MODDBG_PF_HIGHER);
			MODDBG(NPF_MODDBG_LA_MY);
			MODDBG(NPF_MODDBG_LA_HIGHER);
			MODDBG(NPF_MODDBG_BITS);
			MODDBG(NPF_MODDBG_MAXFRAME);
			MODDBG(NPF_MODDBG_NUMOPENS);
#endif
			HeapFree(GetProcessHeap(), 0, OidData);
			PacketCloseAdapter(dev);
		}
		else {
			_tprintf(_T("\tFAILED: %08x\n"), GetLastError());
		}
next_name:
		name += strlen(name) + 1;
		desc += strlen(desc) + 1;
	}

	HeapFree(GetProcessHeap(), 0, AdapterNames);
	return;
}

int main()
{
	/* Load Npcap and its functions. */
	if (!LoadNpcapDlls())
	{
		_ftprintf(stderr, _T("Couldn't load Npcap\n"));
		exit(1);
	}

	//
	// Obtain the name of the adapters installed on this machine
	//

	_tprintf(_T("Packet.dll test application.\n"));
       	_tprintf(_T("Library version: %hs\n"), PacketGetVersion());
       	_tprintf(_T("Driver version: %hs\n"), PacketGetDriverVersion());
	
	ULONG ulInfo = 0;
	USHORT usStat[2] = {0};
	PULONG pulWhere = NULL;
	DWORD err = ERROR_SUCCESS;
	ULONG ulVersion = 0;

#define _GETINFO(_Name, _strName, _SubName, _strSubName, _Ptr, _Size, _Minver, _Block) do { \
	pulWhere = (ULONG *) _Ptr; \
	*pulWhere = _SubName; \
	err = doPacketGetInfo(NULL, _Name, pulWhere, _Size); \
	if (err == ERROR_SUCCESS) { \
		_Block; \
	} \
	else if (ulVersion > _Minver) { \
		_tprintf(_T("PacketGetInfo(" _strName " / " _strSubName ") error: %08x\n"), \
				GetLastError()); \
	} \
} while (0);

#define GETINFO(_Name, _Var) _GETINFO(_Name, #_Name, 0, "", &_Var, sizeof(ULONG), 0, \
		_tprintf(_T( #_Name ": %08x\n"), _Var) )

	GETINFO(NPF_GETINFO_VERSION, ulVersion);

	GETINFO(NPF_GETINFO_CONFIG, ulInfo);
	GETINFO(NPF_GETINFO_BPFEXT, ulInfo);
	GETINFO(NPF_GETINFO_MODES, ulInfo);

#define GETSTATS(_Name) _GETINFO(NPF_GETINFO_STATS, "NPF_GETINFO_STATS", \
		_Name, #_Name, usStat, 2 * sizeof(USHORT), 0x01540000, \
		_tprintf(_T( #_Name ": %hu, %hu\n"), usStat[0], usStat[1]) )

	GETSTATS(NPF_STATSINFO_RECVTIMES);
	GETSTATS(NPF_STATSINFO_SENDTIMES);
	GETSTATS(NPF_STATSINFO_DPCTIMES);

	_tprintf(_T("Adapters installed:\n"));
	printAdapters();

	return (0);
}
