/***********************IMPORTANT NPCAP LICENSE TERMS***********************
 *
 * Npcap (https://npcap.com) is a Windows packet sniffing driver and library and
 * is copyright (c) 2013-2025 by Nmap Software LLC ("The Nmap Project").  All
 * rights reserved.
 *
 * Even though Npcap source code is publicly available for review, it is not
 * open source software and may not be redistributed or used in other software
 * without special permission from the Nmap Project. The standard (free) version
 * is usually limited to installation on five systems. For more details, see the
 * LICENSE file included with Npcap and also available at
 * https://github.com/nmap/npcap/blob/master/LICENSE. This header file
 * summarizes a few important aspects of the Npcap license, but is not a
 * substitute for that full Npcap license agreement.
 *
 * We fund the Npcap project by selling two types of commercial licenses to a
 * special Npcap OEM edition:
 *
 * 1) The Npcap OEM Redistribution License allows companies distribute Npcap OEM
 * within their products. Licensees generally use the Npcap OEM silent
 * installer, ensuring a seamless experience for end users. Licensees may choose
 * between a perpetual unlimited license or a quarterly term license, along with
 * options for commercial support and updates. Prices and details:
 * https://npcap.com/oem/redist.html
 *
 * 2) The Npcap OEM Internal-Use License is for organizations that wish to use
 * Npcap OEM internally, without redistribution outside their organization. This
 * allows them to bypass the 5-system usage cap of the Npcap free edition. It
 * includes commercial support and update options, and provides the extra Npcap
 * OEM features such as the silent installer for automated deployment. Prices
 * and details: https://npcap.com/oem/internal.html
 *
 * Both of these licenses include updates and support as well as a warranty.
 * Npcap OEM also includes a silent installer for unattended installation.
 * Further details about Npcap OEM are available from https://npcap.com/oem/,
 * and you are also welcome to contact us at sales@nmap.com to ask any questions
 * or set up a license for your organization.
 *
 * Free and open source software producers are also welcome to contact us for
 * redistribution requests. However, we normally recommend that such authors
 * instead ask your users to download and install Npcap themselves. It will be
 * free for them if they need 5 or fewer copies.
 *
 * If the Nmap Project (directly or through one of our commercial licensing
 * customers) has granted you additional rights to Npcap or Npcap OEM, those
 * additional rights take precedence where they conflict with the terms of the
 * license agreement.
 *
 * Since the Npcap source code is available for download and review, users
 * sometimes contribute code patches to fix bugs or add new features. By sending
 * these changes to the Nmap Project (including through direct email or our
 * mailing lists or submitting pull requests through our source code
 * repository), it is understood unless you specify otherwise that you are
 * offering the Nmap Project the unlimited, non-exclusive right to reuse,
 * modify, and relicense your code contribution so that we may (but are not
 * obligated to) incorporate it into Npcap. If you wish to specify special
 * license conditions or restrictions on your contributions, just say so when
 * you send them.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. Warranty rights and commercial support are
 * available for the OEM Edition described above.
 *
 * Other copyright notices and attribution may appear below this license header.
 * We have kept those for attribution purposes, but any license terms granted by
 * those notices apply only to their original work, and not to any changes made
 * by the Nmap Project or to this entire file.
 *
 ***************************************************************************/
/*
 * Copyright (c) 1999 - 2005 NetGroup, Politecnico di Torino (Italy)
 * Copyright (c) 2005 - 2010 CACE Technologies, Davis (California)
 * Copyright (c) 2010 - 2013 Riverbed Technology, San Francisco (California), Yang Luo (China)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Politecnico di Torino, CACE Technologies
 * nor the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef NPCAP_DEFS_H
#define NPCAP_DEFS_H
/* Data structures and constants used by Npcap's driver and DLLs. */

typedef unsigned long ULONG;
typedef unsigned char UCHAR;

/*!
  \brief Structure containing an OID request.

  It is used by the PacketRequest() function to send an OID to the interface card driver. 
  It can be used, for example, to retrieve the status of the error counters on the adapter, its MAC address, 
  the list of the multicast groups defined on it, and so on.
*/
struct _PACKET_OID_DATA
{
	ULONG Oid; ///< OID code. See the Microsoft DDK documentation or the file ntddndis.h
	///< for a complete list of valid codes.
	ULONG Length; ///< Length of the data field
#ifdef _Field_size_full_  /* SAL annotation */
	_Field_size_full_(Length)
#endif
	UCHAR Data[1]; ///< variable-length field that contains the information passed to or received
	///< from the adapter.
}; 
typedef struct _PACKET_OID_DATA PACKET_OID_DATA, * PPACKET_OID_DATA;
#ifdef C_ASSERT
C_ASSERT(sizeof(PACKET_OID_DATA) == 12);
#endif

#define PACKET_OID_DATA_LENGTH(_DataLength) \
	(FIELD_OFFSET(PACKET_OID_DATA, Data) + _DataLength)

/* Info IDs for PacketGetInfo/BIOCGETINFO */
// Version of driver. Output is ULONG in MMmmbbbb format
#define NPF_GETINFO_VERSION 0x00000001
// Bitfield of capabilities, configs, and build attributes. Output is ULONG.
#define NPF_GETINFO_CONFIG 0x00000002
#define NPF_CONFIG_OEM       0x01 /* Npcap OEM */
#define NPF_CONFIG_INJECT    0x02 /* ifndef NPCAP_READ_ONLY */
#define NPF_CONFIG_ADMINONLY 0x04 /* AdminOnly */
#define NPF_CONFIG_DLTNULL   0x08 /* DltNull */
#define NPF_CONFIG_WIFI      0x10 /* Dot11Support */
#define NPF_CONFIG_LOOPBACK  0x20 /* LoopbackSupport */
#define NPF_CONFIG_TESTMODE  0x40 /* TestMode */
// BPF Extensions supported. Output is ULONG, max extension supported.
#define NPF_GETINFO_BPFEXT 0x00000003
// Supported mode bits for BIOCSMODE (PacketSetMode, pcap_setmode). Output is ULONG.
#define NPF_GETINFO_MODES 0x00000004
// Performance statistics for the filter module
#define NPF_GETINFO_STATS 0x00000005
// All of these are 2 USHORTs: average for last 10 and last 10K calls
#define NPF_STATSINFO_RECVTIMES 0x00000001 /* ticks per recieve indication */
#define NPF_STATSINFO_SENDTIMES 0x00000002 /* ticks per send indication */
#define NPF_STATSINFO_DPCTIMES  0x00000003 /* ticks at DPC level, both dirs */
// Internal debugging info unique to a filter module
#define NPF_GETINFO_MODDBG 0x00000006
// Subrequests of NPF_GETINFO_MODDBG
#define NPF_MODDBG_PF_SUPPORTED 0x00000001
#define NPF_MODDBG_PF_MY        0x00000002
#define NPF_MODDBG_PF_HIGHER    0x00000003
#define NPF_MODDBG_LA_MY        0x00000004
#define NPF_MODDBG_LA_HIGHER    0x00000005
#define NPF_MODDBG_BITS         0x00000006
#define NPF_MODDBG_MAXFRAME     0x00000007
#define NPF_MODDBG_NUMOPENS     0x00000008

#endif /* NPCAP_DEFS_H */
